import { View, FlatList } from "react-native";
import React, { useEffect } from "react";
import { ProfileStyles } from "../../Profile/ProfileStyle";
import BackNavigation from "../../Utilities/CustomHeader/BackNavigation";
import { useState } from "react";
import FeatureProductSkeleton from "../../../src/skeletons/screens/home/FeatureProductSkeleton";
import NoWishlistIcon from "../../../assets/svgs/empty content/noWishlist.svg";
import { useNavigation } from "@react-navigation/native";
import { query } from "../../../redux/slices/util/apiRequest";
import SingleProduct from "../../../src/components/SingleProduct/SingleProduct";
import { featureDisplayStyle } from "./featureDisplay.style";
import EmptyContent from "../../Utilities/EmptyContent/EmptyContent";
import { useMemo } from "react";
import { filterProductData } from "./filterProductData";
import { ProductsStyle } from "../FeaturedProducts/featureProductsStyle";
import { getPreferences } from "../../../redux/slices/preferences/getPreferences";
import { useDispatch } from "react-redux";
import CustomActiveIndicator from "../../../src/components/CustomLoader/CustomActiveIndicator";
import useLangTranslation from "../../../hooks/useLangTranslation";

const FeatureDisplay = (props) => {
    const { trans } = useLangTranslation();
    const { name, url } = props?.route?.params;
    const [products, setProducts] = useState([]);
    const [nextPageUrl, SetNextPageUrl] = useState("");
    const [loading, setLoading] = useState(true);
    const [loadMore, setLoadMore] = useState(false);
    const navigation = useNavigation();
    const [routeName, setRouteName] = useState(null);

    const dispatch = useDispatch();

    useEffect(() => {
        let isMounted = true;
        if (isMounted) {
            setRouteName(name);
            handleFetchData(url);
        }
        return () => {
            isMounted = false;
        };
    }, []);
    const handleFetchData = async (url) => {
        let isMounted = true;
        if (isMounted) {
            try {
                setLoading(true);
                const getProducts = await query(url, "GET");
                const { status, records = {} } = getProducts?.response || {};
                if (status?.code == 200) {
                    let newData = filterProductData(records?.data);
                    setProducts(newData);
                    SetNextPageUrl(records?.pagination?.next_page_url);
                    setLoading(false);
                }
            } catch (error) {
                setLoading(false);
            } finally {
            }
        }
        return () => {
            isMounted = false;
        };
    };

    const handleMoreData = async () => {
        let isMounted = true;
        if (isMounted && nextPageUrl && !loadMore) {
            try {
                setLoadMore(true);
                const getProducts = await query(nextPageUrl, "GET");
                const { status, records } = getProducts?.response || {};
                if (status?.code == 200) {
                    let newData = filterProductData(records?.data);
                    setProducts(products.concat(newData));
                    SetNextPageUrl(records?.pagination?.next_page_url);
                }
            } catch (error) {
            } finally {
                setLoadMore(false);
            }
        }
        return () => {
            isMounted = false;
        };
    };

    const memorizeItem = useMemo(
        () =>
            ({ item }) =>
                <SingleProduct item={item} navigation={navigation} />,
        []
    );

    const handleRefresh = async () => {
        handleFetchData(url);
        dispatch(getPreferences());
    };
    const productsStyle = ProductsStyle();

    return (
        <>
            <BackNavigation
                navigationProps={props.navigation}
                routeName={routeName ?? ""}
                capitalize={true}
            />
            <View style={ProfileStyles.hrLine} />
            <View style={[featureDisplayStyle.const, featureDisplayStyle.py]}>
                <View>
                    {loading ? (
                        <FeatureProductSkeleton />
                    ) : products?.length > 0 ? (
                        <FlatList
                            data={products}
                            keyExtractor={(_, i) => "key-A" + i}
                            listKey={(_, i) => `listKey-A${i}`}
                            renderItem={memorizeItem}
                            showsVerticalScrollIndicator={false}
                            numColumns={2}
                            columnWrapperStyle={
                                featureDisplayStyle.justifyContent
                            }
                            refreshing={false}
                            onRefresh={handleRefresh}
                            onEndReachedThreshold={0.5}
                            onEndReached={handleMoreData}
                        />
                    ) : (
                        <FlatList
                            refreshing={false}
                            onRefresh={handleRefresh}
                            showsVerticalScrollIndicator={false}
                            ListHeaderComponent={() => (
                                <EmptyContent
                                    Icon={NoWishlistIcon}
                                    text={trans("No Product Found")}
                                />
                            )}
                        />
                    )}
                </View>
            </View>
            {loadMore && <CustomActiveIndicator />}
        </>
    );
};

export default FeatureDisplay;
